/*= <KEITHLEY 7001> =========================================================*/
/* LabWindows/CVI Instrument Driver                                      	 */
/* Original Release:                                                         */
/* By: Alain Laine                                                           */
/*     PH. 33/1/60/11/51/55   												 */
/*     Fax : 33/1/60/11/77/26     											 */
/*     Email : Laine_alain@keithley.com        				                 */
/*                                                                           */
/* Modification History: None                                                */
/*===========================================================================*/
     
#ifndef __Ki7001_HEADER
#define __Ki7001_HEADER

#include <vpptype.h>

#if defined(__cplusplus) || defined(__cplusplus__)
extern "C" {
#endif

/*****************************************************************************/
/*= Define Instrument Specific Error/Warning Codes Here ====7=================*/
/*****************************************************************************/
#define VI_ERROR_INSTR_FILE_OPEN                (_VI_ERROR+0x3FFC0800L)
#define VI_ERROR_INSTR_FILE_WRITE               (_VI_ERROR+0x3FFC0801L)
#define VI_ERROR_INSTR_INTERPRETING_RESPONSE    (_VI_ERROR+0x3FFC0803L)

#define VI_INSTR_WARNING_OFFSET                           (0x3FFC0900L)
#define VI_INSTR_ERROR_OFFSET                   (_VI_ERROR+0x3FFC0900L)

#define Ki7001_ERROR_INVALID_CONFIGURATION      (VI_INSTR_ERROR_OFFSET + 0xF0L)

/*****************************************************************************/
/*= Instrument Specific constants to make the user code clearer =============*/
/*****************************************************************************/
/*																			 */
/* We recommend you to use these defined vlaues when programming the 2304	 */
/* This will make your code easier to read									 */
/*																			 */
/* By example :																 */
/* Do not write : Ki2304_SetupSRQ( instrumentHandle, 17);				     */
/* Write : Ki2304_SetupSRQ( instrumentHandle, KI7001_SRQ_ON_READING_AVAIL +  */															 
/*										      KI7001_SRQ_ON_CURRENT_LIMIT);	 */
/*																			 */
/*****************************************************************************/

#define KI7001_DEFAULT_DISPLAY		0
#define KI7001_USER_DISPLAY			1

#define KI7001_INTERNAL_TTL			1
#define KI7001_SLOT1_TTL			2
#define KI7001_SLOT2_TTL			3

#define RST_SETUP					-2
#define PRES_SETUP					-1
#define USER0_SETUP					0
#define USER1_SETUP					1
#define USER2_SETUP					2
#define USER3_SETUP					3
#define USER4_SETUP					4
#define USER5_SETUP					5
#define USER6_SETUP					6
#define USER7_SETUP					7
#define USER8_SETUP					8
#define USER9_SETUP					9

#define KI7001_REG_SRE				0
#define KI7001_REG_ESE				1
#define KI7001_REG_OPER_ENAB		2
#define KI7001_REG_OPER_TRANS		3
#define KI7001_REG_ARM_ENAB			4
#define KI7001_REG_ARM_TRANS		5
#define KI7001_REG_SEQ_ENAB			6
#define KI7001_REG_SEQ_TRANS		7
#define KI7001_REG_QUES_ENAB		8
#define KI7001_REG_QUES_TRANS		9
#define KI7001_REG_TRIG_ENAB		10
#define KI7001_REG_TRIG_TRANS		11
#define KI7001_REG_STB				12
#define KI7001_REG_ESE_EVENT		13
#define KI7001_REG_OPER_EVENT		14
#define KI7001_REG_OPER_COND		15
#define KI7001_REG_ARM_EVENT		16
#define KI7001_REG_ARM_COND			17
#define KI7001_REG_SEQ_EVENT		18
#define KI7001_REG_SEQ_COND			19
#define KI7001_REG_QUES_EVENT		20
#define KI7001_REG_QUES_COND		21
#define KI7001_REG_TRIG_EVENT		22
#define KI7001_REG_TRIG_COND		23

#define KI7001_CLEAR_SRQ_CONDITION     0x0000    //Clear all SRQ condition
#define KI7001_SRQ_ON_IN_TRIG_LAYER    0x0001
#define KI7001_SRQ_ON_IN_ARM_LAYER1    0x0002
#define KI7001_SRQ_ON_IN_ARM_LAYER2    0x0004
#define KI7001_SRQ_ON_SETTLING		   0x0008
#define KI7001_SRQ_ON_IN_IDLE		   0x0010
#define KI7001_SRQ_ON_ERROR_AVAIL      0x0020
#define KI7001_SRQ_ON_MESSAGE_AVAIL    0x0040
#define KI7001_SRQ_ON_OP_COMPLETED     0x0080
#define KI7001_SRQ_ON_REQCTRL          0x0100
#define KI7001_SRQ_ON_DEVICE_ERROR     0x0200
#define KI7001_SRQ_ON_EXEC_ERROR       0x0400
#define KI7001_SRQ_ON_CMD_ERROR        0x0800
#define KI7001_SRQ_ON_USER_REQUEST     0x1000

#define KI7001_TRIG_ON_IMMEDIATE		0
#define KI7001_TRIG_ON_MANUAL			1
#define KI7001_TRIG_ON_BUS				2
#define KI7001_TRIG_ON_EXTERNAL			3
#define KI7001_TRIG_ON_TLINK			4
#define KI7001_TRIG_ON_TIMER			5

#define KI7001_ACCEPTOR					0
#define KI7001_SOURCE					1

#define KI7001_TLINK_LINE1				1
#define KI7001_TLINK_LINE2				2
#define KI7001_TLINK_LINE3				3
#define KI7001_TLINK_LINE4				4
#define KI7001_TLINK_LINE5				5
#define KI7001_TLINK_LINE6				6

#define KI7001_ARM_LAYER				0
#define KI7001_SCAN_LAYER				1
#define KI7001_CHAN_LAYER				2

#define KI7001_CARD_7052				7052
#define KI7001_CARD_7053				7053
#define KI7001_CARD_7054				7054
#define KI7001_CARD_7056				7056
#define KI7001_CARD_7057				7057
#define KI7001_CARD_7058				7058
#define KI7001_CARD_7059				7059
#define KI7001_CARD_7061				7061
#define KI7001_CARD_7062				7062
#define KI7001_CARD_7063				7063
#define KI7001_CARD_7064				7064
#define KI7001_CARD_7065				7065
#define KI7001_CARD_7066				7066
#define KI7001_CARD_7067				7067
#define KI7001_CARD_7152				7152
#define KI7001_CARD_7153				7153
#define KI7001_CARD_7154				7154
#define KI7001_CARD_7156				7156
#define KI7001_CARD_7158				7158
#define KI7001_CARD_7164				7164
#define KI7001_CARD_7166				7166
#define KI7001_CARD_7168				7168
#define KI7001_CARD_7169				7169
#define KI7001_CARD_7402				7402
#define KI7001_CARD_9990				9990
#define KI7001_CARD_9991				9991

#define KI7001_1_POLE					1
#define KI7001_2_POLES					2
#define KI7001_4_POLES					4

#define KI7001_ENABLE					1
#define KI7001_DISBLE					0

/*****************************************************************************/
/*= GLOBAL USER-CALLABLE FUNCTION DECLARATIONS (Exportable Functions) =======*/
/*****************************************************************************/
ViStatus _VI_FUNC Ki7001_init (ViRsrc resourceName,
                    ViBoolean resetDevice, ViPSession instrSession);

/** INSERT USER-CALLABLE INSTRUMENT-DEPENDENT FUNCTION DECLARATIONS HERE **/

ViStatus _VI_FUNC Ki7001_reset (ViSession instrSession);
ViStatus _VI_FUNC Ki7001_selfTest (ViSession instrSession, ViPInt16 selfTestResult,
                    ViChar _VI_FAR selfTestMessage[]);
ViStatus _VI_FUNC Ki7001_errorQuery (ViSession instrSession, ViPInt32 errorCode,
                    ViChar _VI_FAR errorMessage[]);
ViStatus _VI_FUNC Ki7001_errorMessage (ViSession instrSession, ViStatus statusCode,
                    ViChar _VI_FAR message[]);
ViStatus _VI_FUNC Ki7001_revisionQuery (ViSession instrSession,
                    ViChar _VI_FAR driverRev[], ViChar _VI_FAR instrRev[]);
ViStatus _VI_FUNC Ki7001_close (ViSession instrSession);

ViStatus Ki7001_FrontPanel (ViSession instrumentHandle, ViInt16 window,
                            ViInt16 displayMode, ViChar userMessage[]);

ViStatus Ki7001_TTLOutput (ViSession instrumentHandle, ViInt16 value);

ViStatus Ki7001_TTLInput (ViSession instrumentHandle, ViInt16 *result, int origin);

ViStatus Ki7001_SaveSetup (ViSession instrumentHandle, ViInt16 setupNumber);
ViStatus Ki7001_RecallSetup (ViSession instrumentHandle, ViInt16 setupNumber);
ViStatus Ki7001_POSetup (ViSession instrumentHandle, ViInt16 setup);
ViStatus Ki7001_WriteRegister (ViSession instrumentHandle, ViInt16 reg,
                               ViInt16 value);
ViStatus Ki7001_ReadRegister (ViSession instrumentHandle, ViInt16 reg,
                              ViInt16 *value);
ViStatus Ki7001_ClearRegisters (ViSession instrumentHandle);
ViStatus Ki7001_SetupSRQ (ViSession instrumentHandle, ViInt32 condition);
ViStatus Ki7001_SetupArmLayer (ViSession instrumentHandle, ViInt16 source,
                               ViInt16 count, ViInt16 direction,
                               ViInt16 triggerLinkInputLine,
                               ViInt16 triggerLinkOutputLine);
ViStatus Ki7001_SetupScanLayer (ViSession instrumentHandle, ViInt16 source,
                                ViInt16 count, ViInt16 direction, ViReal64 timer,
                                ViReal64 delay, ViInt16 triggerLinkInputLine,
                                ViInt16 triggerLinkOutputLine);
ViStatus Ki7001_SetupChanLayer (ViSession instrumentHandle, ViInt16 source,
                                ViInt16 count, ViInt16 direction, ViReal64 timer,
                                ViReal64 delay, ViInt16 triggerLinkInputLine,
                                ViInt16 triggerLinkOutputLine);
ViStatus Ki7001_Bypass (ViSession instrumentHandle,  ViInt16 Layer, int bypassDelay);
ViStatus Ki7001_Start (ViSession instrumentHandle, int continuousInit);
ViStatus Ki7001_Stop (ViSession instrumentHandle);

ViStatus Ki7001_DefineScannerCard (ViSession instrumentHandle, ViInt16 slot,
                                   ViInt16 type);
ViStatus Ki7001_QueryScannerCard (ViSession instrumentHandle, ViInt16 slot,
                                  ViInt16 *type);
ViStatus Ki7001_SetPoles (ViSession instrumentHandle, ViInt16 slot, ViInt16 poles);
ViStatus Ki7001_QueryPoles (ViSession instrumentHandle, ViInt16 slot,
                            ViInt16 *poles);
ViStatus Ki7001_SetSettlingTime (ViSession instrumentHandle, ViInt16 slot,
                                 ViReal64 settlingTime);
ViStatus Ki7001_QuerySettlingTime (ViSession instrumentHandle, ViInt16 slot,
                                   ViReal64 *settlingTime);
ViStatus Ki7001_EnableBBM (ViSession instrumentHandle, ViInt16 enable);
ViStatus Ki7001_QueryBBM (ViSession instrumentHandle, ViInt16 *BBM);
ViStatus Ki7001_EnableSingleChan (ViSession instrumentHandle, ViInt16 enable);
ViStatus Ki7001_QuerySingleChan (ViSession instrumentHandle, ViInt16 *mode);
ViStatus Ki7001_EnableCardPairing (ViSession instrumentHandle, ViInt16 enable);
ViStatus Ki7001_QueryCardPairing (ViSession instrumentHandle, ViInt16 *mode);

ViStatus Ki7001_Close (ViSession instrumentHandle, ViChar channelList[]);
ViStatus Ki7001_Open (ViSession instrumentHandle, ViChar channelList[]);
ViStatus Ki7001_OpenAll (ViSession instrumentHandle);
ViStatus Ki7001_ScanList (ViSession instrumentHandle, ViChar channelList[]);
ViStatus Ki7001_StoreRelayPattern (ViSession instrumentHandle, ViInt16 pattern);
ViStatus Ki7001_RecallRelayPattern (ViSession instrumentHandle, ViInt16 pattern);

/* HELPERS */

char *Ki7001_MAKESCANCHAN (char *buffer, int slot, int row, int column);
char *Ki7001_MAKEMUXCHAN (char *buffer, int slot, int channel);
char *Ki7001_MAKEMEMCHAN (char *buffer, int memory);
char *Ki7001_MAKECONTIGUOUSLIST (char *buffer, char *start, char *stop);
char *Ki7001_ADDTOLIST (char *buffer, char *actual, char *new);

#if defined(__cplusplus) || defined(__cplusplus__)
}
#endif

/*****************************************************************************/
/*=== END INCLUDE FILE ======================================================*/
/*****************************************************************************/

#endif
